/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.EnumSet;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.MariaDbBlob;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ColumnDecoder;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.Context;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.socket.Writer;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.Codec;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.plugin.codec.ByteArrayCodec;

public class BlobCodec
implements Codec<Blob> {
    public static final BlobCodec INSTANCE = new BlobCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BIT, new DataType[]{DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.STRING, DataType.VARSTRING, DataType.VARCHAR});

    @Override
    public String className() {
        return Blob.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Blob.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Blob && !(value instanceof Clob);
    }

    @Override
    public Blob decodeText(ReadableByteBuf buf, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case STRING: 
            case VARCHAR: 
            case VARSTRING: {
                if (!column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s (not binary) cannot be decoded as Blob", new Object[]{column.getType()}));
                }
            }
            case BIT: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case BLOB: 
            case GEOMETRY: {
                if (!column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s (not binary) cannot be decoded as Blob", new Object[]{column.getType()}));
                }
                return buf.readBlob(length);
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Blob", new Object[]{column.getType()}));
    }

    @Override
    public Blob decodeBinary(ReadableByteBuf buf, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case STRING: 
            case VARCHAR: 
            case VARSTRING: {
                if (!column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s (not binary) cannot be decoded as Blob", new Object[]{column.getType()}));
                }
            }
            case BIT: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: 
            case BLOB: 
            case GEOMETRY: {
                if (!column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s (not binary) cannot be decoded as Blob", new Object[]{column.getType()}));
                }
                buf.skip(length);
                return new MariaDbBlob(buf.buf(), buf.pos() - length, length);
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Blob", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException, SQLException {
        encoder.writeBytes(ByteArrayCodec.BINARY_PREFIX);
        byte[] array = new byte[4096];
        InputStream is = ((Blob)value).getBinaryStream();
        if (maxLength == null) {
            int len;
            while ((len = is.read(array)) > 0) {
                encoder.writeBytesEscaped(array, len, (context.getServerStatus() & 0x200) != 0);
            }
        } else {
            int len;
            for (long maxLen = maxLength.longValue(); maxLen > 0L && (len = is.read(array)) > 0; maxLen -= (long)len) {
                encoder.writeBytesEscaped(array, Math.min(len, (int)maxLen), (context.getServerStatus() & 0x200) != 0);
            }
        }
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException, SQLException {
        InputStream is = ((Blob)value).getBinaryStream();
        try {
            int len;
            long length = ((Blob)value).length();
            if (maxLength != null) {
                length = Math.min(maxLength, length);
            }
            encoder.writeLength(length);
            byte[] array = new byte[4096];
            long remainingLen = length;
            while ((len = is.read(array)) > 0) {
                encoder.writeBytes(array, 0, Math.min((int)remainingLen, len));
                if ((remainingLen -= (long)len) >= 0L) continue;
                break;
            }
        }
        catch (SQLException sqle) {
            byte[] val = this.encode(is, maxLength);
            encoder.writeLength(val.length);
            encoder.writeBytes(val, 0, val.length);
        }
    }

    @Override
    public void encodeLongData(Writer encoder, Blob value, Long maxLength) throws IOException, SQLException {
        byte[] array = new byte[4096];
        InputStream is = value.getBinaryStream();
        if (maxLength == null) {
            int len;
            while ((len = is.read(array)) > 0) {
                encoder.writeBytes(array, 0, len);
            }
        } else {
            int len;
            for (long maxLen = maxLength.longValue(); maxLen > 0L && (len = is.read(array)) > 0; maxLen -= (long)len) {
                encoder.writeBytes(array, 0, Math.min(len, (int)maxLen));
            }
        }
    }

    @Override
    public byte[] encodeData(Blob value, Long maxLength) throws IOException, SQLException {
        return this.encode(value.getBinaryStream(), maxLength);
    }

    private byte[] encode(InputStream is, Long maxLength) throws IOException {
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        byte[] array = new byte[4096];
        if (maxLength == null) {
            int len;
            while ((len = is.read(array)) > 0) {
                bb.write(array, 0, len);
            }
        } else {
            int len;
            for (long maxLen = maxLength.longValue(); maxLen > 0L && (len = is.read(array)) > 0; maxLen -= (long)len) {
                bb.write(array, 0, Math.min(len, (int)maxLen));
            }
        }
        return bb.toByteArray();
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }

    @Override
    public boolean canEncodeLongData() {
        return true;
    }
}

